/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.item;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.block.CustomProperties;
import com.github.mim1q.convenientdecor.block.blockentity.WateringCanBlockEntity;
import com.github.mim1q.convenientdecor.init.ModBlocks;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class WateringCanItem
extends Item {
    public static final int MAX_WATER_LEVEL = 32;
    public static final String WATER_LEVEL_KEY = "item.convenientdecor.watering_can.water_level";

    public WateringCanItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        BlockEntity entity;
        BlockHitResult hitResult = WateringCanItem.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.WATER);
        ItemStack stack = user.m_21120_(hand);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        InteractionResultHolder<ItemStack> result = this.tryUseOnBlock(world, user, stack, hitResult);
        if (result != null) {
            return result;
        }
        BlockPlaceContext ctx = new BlockPlaceContext(user, hand, stack, hitResult);
        InteractionResultHolder<ItemStack> result2 = this.tryPlace(ctx);
        if (result2.m_19089_().m_19077_() && (entity = world.m_7702_(ctx.m_8083_())) instanceof WateringCanBlockEntity) {
            WateringCanBlockEntity wateringCan = (WateringCanBlockEntity)entity;
            wateringCan.m_187476_(stack);
        }
        return result2;
    }

    protected InteractionResultHolder<ItemStack> tryUseOnBlock(Level world, Player user, ItemStack stack, BlockHitResult hitResult) {
        Vec3 pos = hitResult.m_82450_();
        BlockState state = world.m_8055_(hitResult.m_82425_());
        if (state.m_60819_().m_205070_(FluidTags.f_13131_)) {
            if (WateringCanItem.getWaterLevel(stack) < 32) {
                WateringCanItem.setWaterLevel(stack, 32);
                world.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f, true);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (state.m_60713_(Blocks.f_50093_) && ConvenientDecor.CONFIG.features.wateringCanPermanentFarmland) {
            if (user.m_6144_()) {
                return null;
            }
            if (!WateringCanItem.canWater(stack) || ((Boolean)state.m_61143_((Property)CustomProperties.HYDRATED)).booleanValue()) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            WateringCanItem.setWaterLevel(stack, WateringCanItem.getWaterLevel(stack) - 1);
            world.m_46597_(hitResult.m_82425_(), (BlockState)((BlockState)Blocks.f_50093_.m_49966_().m_61124_((Property)CustomProperties.HYDRATED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)));
            world.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11778_, SoundSource.PLAYERS, 1.0f, 1.0f, true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return null;
    }

    protected InteractionResultHolder<ItemStack> tryPlace(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = world.m_8055_(pos);
        ItemStack stack = ctx.m_43722_();
        Player user = ctx.m_43723_();
        BlockState newState = ModBlocks.WATERING_CAN.m_5573_(ctx);
        if (!world.m_45752_(newState, pos, CollisionContext.m_82749_())) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (state.m_247087_()) {
            world.m_46597_(pos, newState);
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12065_, SoundSource.BLOCKS, (SoundType.f_56743_.m_56773_() + 1.0f) / 2.0f, SoundType.f_56743_.m_56774_() * 0.8f, true);
            world.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)user, (BlockState)newState));
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        tooltip.add((Component)Component.m_237110_((String)WATER_LEVEL_KEY, (Object[])new Object[]{WateringCanItem.getWaterLevel(stack), 32}).m_130940_(ChatFormatting.AQUA));
    }

    public boolean m_142522_(ItemStack stack) {
        return WateringCanItem.getWaterLevel(stack) < 32;
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        WateringCanItem.setWaterLevel(stack, 0);
        return stack;
    }

    public ItemStack getStack(int waterLevel) {
        ItemStack stack = super.m_7968_();
        WateringCanItem.setWaterLevel(stack, waterLevel);
        return stack;
    }

    public int m_142159_(ItemStack stack) {
        return 43775;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)WateringCanItem.getWaterLevel(stack) / 32.0f * 13.0f);
    }

    public static int getWaterLevel(ItemStack stack) {
        return stack.m_41784_().m_128451_("WaterLevel");
    }

    public static void setWaterLevel(ItemStack stack, int waterLevel) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) == 0 || waterLevel > WateringCanItem.getWaterLevel(stack)) {
            stack.m_41784_().m_128405_("WaterLevel", waterLevel);
        }
    }

    public static boolean canWater(ItemStack stack) {
        return WateringCanItem.getWaterLevel(stack) > 0;
    }
}

